# 命名作用域
作用域决定了哪些变量可以从哪里访问。简单来说，作用域就是一个从名称到值的映射。
其工作方式与 Python 中的基本相同。

首先存在一个全局作用域，其次每个函数都有一个局部作用域。
当定义一个变量时，它会被添加到当前作用域。
函数定义之外的一切都被视为全局作用域的一部分。

`x = 1`
在全局作用域中将值 `1` 赋给名称 `x`。

以下 `def` 语句在全局作用域中将一个函数赋给名称 `f`。
`def f():
    `在 `f` 的局部作用域中将值 `1` 赋给名称 `y`。`
    y = 1

    `在 `f` 的局部作用域中将一个函数赋给名称 `g`。`
    def g():
        pass`

`f()`
从全局作用域中检索存储在 `f` 中的函数并调用它。

`print(y)`
这个在全局作用域中的 print 语句会抛出一个错误，因为 `y` 从未在全局作用域中声明，所以无法在这里读取它。
它只存在于 `f` 的局部作用域中。

## global 关键字
默认情况下，函数中的所有变量都绑定到局部作用域，即使全局作用域中存在同名变量。

`x = 0

def f():
    x = 1
f()
print(x)`

这段代码会打印 `0`，因为 `f` 内部的局部 `x` 与全局 `x` 不是同一个变量，所以全局 `x` 保持不变。这一点很重要，否则函数调用可能会意外覆盖一个恰好与该函数局部变量同名的全局变量。

如果想写入一个全局变量，则必须使用 `global` 关键字来明确表示。

`x = 0

def f():
    global x
    x = 1
f()
print(x)`

在这个例子中，`global x` 将 `x` 绑定到上面定义的全局变量 `x`。现在打印的会是 `1`。
注意，改变全局变量通常是走向面条式代码（shi山）的第一步，导致程序的每个部分都会影响其他所有部分，所以请勿过度使用。

## 循环和分支
循环和分支不会创建自己的作用域，因此，在其内部声明的一切都仍然可以在外部使用。

`for i in range(3):
    pass
print(i)`

这将打印 `2`，因为 `for` 循环的最后一次迭代将 `2` 赋给了 `i`。